within Buildings.Controls;
package OBC "Blocks and preconfigured control sequences"
  extends Modelica.Icons.VariantsPackage;

annotation (
Documentation(info="<html>
<p>
Package that contains a library of elementary control blocks
and a library that implements control sequences from the ASHRAE Guideline 36.
</p>
<p>
These implementations have been developed
through the OpenBuildingControl (<a href=\"https://obc.lbl.gov\">obc.lbl.gov</a>) project
that develops a process and tools for the
performance evaluation, specification and verification
of building control sequences.
</p>
<p>
For a tutorial for how to implement control sequences using the
Control Description Language (CDL), see
<a href=\"modelica://Buildings.Examples.Tutorial.CDL\">
Buildings.Examples.Tutorial.CDL</a>.
</p>
</html>"));
end OBC;
